<?php
/**
 * Module Name: Events
 * Description: Events Custom Post Type. Generated by Ryan Lyons' CPT Manager
 */

add_action('init', 'port_cpt_create_event_cpt');
function port_cpt_create_event_cpt() {
	$labels = array(
		'name'               => _x( 'Events', 'post type general name' ),
		'singular_name'      => _x( 'Event', 'post type singular name' ),
		'add_new'            => _x( 'Add New', 'event' ),
		'add_new_item'       => __( 'Add New Event' ),
		'edit_item'          => __( 'Edit Event' ),
		'new_item'           => __( 'New Event' ),
		'all_items'          => __( 'All Events' ),
		'view_item'          => __( 'View Event' ),
		'search_items'       => __( 'Search Events' ),
		'not_found'          => __( 'No Events found' ),
		'not_found_in_trash' => __( 'No Events found in the Trash' ),
		'parent_item_colon'  => '',
		'menu_name'          => 'Events'
	  );
	$rewrites = array(
	  'slug'  => 'events',
	  'with_front'  => true
	);
	  $args = array(
		'labels'        => $labels,
		'description'   => 'Displays Events',
		'public'        => true,
		'menu_position' => 6,
		'menu_icon'     => 'dashicons-welcome-widgets-menus',
		'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
		'has_archive'   => true,
		'show_in_rest'  => true,
		'rewrite'       => $rewrites
	);
	
	register_post_type('events', $args);			
}

add_action( 'init', 'port_cpt_taxonomy_event_type', 0 );
function port_cpt_taxonomy_event_type() {
  $labels = array(
    'name' => _x( 'Event Type', 'taxonomy general name' ),
    'singular_name' => _x( 'Event Type', 'taxonomy singular name' ),
    'search_items' =>  __( 'Search Event Types' ),
    'all_items' => __( 'All Event Types' ),
    'parent_item' => __( 'Parent Event Type' ),
    'parent_item_colon' => __( 'Parent Event Type:' ),
    'edit_item' => __( 'Edit Event Type' ),
    'update_item' => __( 'Update Event Type' ),
    'add_new_item' => __( 'Add New Event Type' ),
    'new_item_name' => __( 'New Event Type' ),
    'menu_name' => __( 'Event Types' ),
  );

  register_taxonomy('event-type', 'events', array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'event-type', 'with_front' => false ),
    'show_in_rest' => true,
  ));
}
