<?php
/**
 * Module Name: Services
 * Description: Services Custom Post Type. Generated by Ryan Lyons' CPT Manager
 */

add_action('init', 'port_cpt_create_service_cpt');
function port_cpt_create_service_cpt() {
	$labels = array(
		'name'               => _x( 'Services', 'post type general name' ),
		'singular_name'      => _x( 'Service', 'post type singular name' ),
		'add_new'            => _x( 'Add New', 'service' ),
		'add_new_item'       => __( 'Add New Service' ),
		'edit_item'          => __( 'Edit Service' ),
		'new_item'           => __( 'New Service' ),
		'all_items'          => __( 'All Services' ),
		'view_item'          => __( 'View Service' ),
		'search_items'       => __( 'Search Services' ),
		'not_found'          => __( 'No Services found' ),
		'not_found_in_trash' => __( 'No Services found in the Trash' ),
		'parent_item_colon'  => '',
		'menu_name'          => 'Services'
	  );
	$rewrites = array(
	  'slug'  => 'services',
	  'with_front'  => true
	);
	  $args = array(
		'labels'        => $labels,
		'description'   => 'Displays Services',
		'public'        => true,
		'menu_position' => 6,
		'menu_icon'     => 'dashicons-welcome-widgets-menus',
		'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
		'has_archive'   => true,
		'show_in_rest'  => true,
		'rewrite'       => $rewrites
	);
	
	register_post_type('services', $args);			
}

add_action( 'init', 'port_cpt_taxonomy_service_type', 0 );
function port_cpt_taxonomy_service_type() {
  $labels = array(
    'name' => _x( 'Service Type', 'taxonomy general name' ),
    'singular_name' => _x( 'Service Type', 'taxonomy singular name' ),
    'search_items' =>  __( 'Search Service Types' ),
    'all_items' => __( 'All Service Types' ),
    'parent_item' => __( 'Parent Service Type' ),
    'parent_item_colon' => __( 'Parent Service Type:' ),
    'edit_item' => __( 'Edit Service Type' ),
    'update_item' => __( 'Update Service Type' ),
    'add_new_item' => __( 'Add New Service Type' ),
    'new_item_name' => __( 'New Service Type' ),
    'menu_name' => __( 'Service Types' ),
  );

  register_taxonomy('service-type', 'services', array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'service-type', 'with_front' => false ),
    'show_in_rest' => true,
  ));
}
