jQuery(document).ready(function($) {
    var currentDomain = window.location.hostname;

    function isExternal(url) {
        var a = document.createElement('a');
        a.href = url;
        return (a.hostname && a.hostname !== currentDomain);
    }

    $('a').on('click', function(e) {
        var linkUrl = $(this).attr('href');
        if (linkUrl && isExternal(linkUrl)) {
            var ajaxurl = myLinkTracker.ajaxurl;
            var nonce = myLinkTracker.nonce;
            
            var data = {
                'action': 'my_link_tracker_log',
                'nonce': nonce,
                'link_url': linkUrl,
                'source_url': window.location.href
            };

            $.post(ajaxurl, data, function(response) {
                console.log('Outbound link click tracked:', linkUrl);
            }).fail(function() {
                 console.error('Failed to track outbound click:', linkUrl);
            }).always(function() {
            });
        }
    });
});