<?php
/**
 * Plugin Name: User Details Plus
 * Description: Addes registration date / time and source to the users page
 * Version: 1.0
 * Author: Ryan Lyons
 * Author URI: https://ryanlyons.dev/
 * License: GPL-2.0+
 */

if (!defined('ABSPATH')) exit;

add_filter( 'manage_users_columns', 'add_registration_date_column' );
function add_registration_date_column( $columns ) {
    $columns['registration_date'] = 'Registered';
    return $columns;
}

add_filter( 'manage_users_custom_column', 'show_registration_date_column_content', 10, 3 );
function show_registration_date_column_content( $value, $column_name, $user_id ) {
    if ( 'registration_date' == $column_name ) {
        $user = get_userdata( $user_id );
        return date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $user->user_registered ) );
    }
    return $value;
}

add_filter( 'manage_users_sortable_columns', 'make_registration_date_column_sortable' );
function make_registration_date_column_sortable( $columns ) {
    $columns['registration_date'] = 'registered';
    return $columns;
}

add_action( 'user_register', 'save_user_registration_source' );
function save_user_registration_source( $user_id ) {
    $referrer = isset( $_SERVER['HTTP_REFERER'] ) ? $_SERVER['HTTP_REFERER'] : 'Direct / Unknown';
    update_user_meta( $user_id, 'registration_source', esc_url_raw( $referrer ) );
}

add_filter( 'manage_users_columns', 'add_source_column' );
function add_source_column( $columns ) {
    $columns['reg_source'] = 'Source';
    return $columns;
}

add_filter( 'manage_users_custom_column', 'show_source_column_content', 10, 3 );
function show_source_column_content( $value, $column_name, $user_id ) {
    if ( 'reg_source' == $column_name ) {
        $source = get_user_meta( $user_id, 'registration_source', true );
        return !empty( $source ) ? esc_html( $source ) : '—';
    }
    return $value;
}

?>